function [ symbols_OUT,max_index_mf_vector,wrong_max_index_mf] = get_symbols_from_package( package_samples_IN, ...
    training_ref_symbols, pulse, fs, f0, R, max_index_mf_vector,wrong_max_index_mf)
%Returns symbols including training symbols
% assuming that the sampling frequency is clearly higher than two times the
% carrier frequency, we can synchronize by taking the cross correlation of
% a training sequence and decide which sample out of the samples/symbols to
% take

k = fs/R;

% matched filtering
mf_pulse = conj(flipud(pulse));

package_baseband_after_mf = conv(package_samples_IN, mf_pulse);

% copy of the training sequence
training_ref_mf = upfirdn(training_ref_symbols, [1 zeros(1,k-1)], k, 1);

% Try all time shifts between t_start and t_end
t_start = 1;
t_end = 2*k-1;
xcor_mf_signal_training = zeros(1,t_end-t_start+1);

for t_tmp = t_start:t_end
   % Save result for this particular t_tmp in array
  
   xcor_mf_signal_training(t_tmp-t_start+1) = ...
       abs(training_ref_mf*...
       package_baseband_after_mf(t_tmp:t_tmp+length(training_ref_mf)-1)');   
   
end

max_index_mf = find(xcor_mf_signal_training == max(xcor_mf_signal_training));

symbols_OUT = package_baseband_after_mf(max_index_mf:k:max_index_mf+length(package_samples_IN)-1);
max_index_mf_vector = [];
max_index_mf_vector = [max_index_mf_vector,max_index_mf];

% if max_index_mf >fs/R
%     wrong_max_index_mf = wrong_max_index_mf+0;
% else
%     wrong_max_index_mf = wrong_max_index_mf+1;
% end

end
